const module_name          = "Progress 10.0B"   'this name must be unique and the VBS File Name !!!
const module_ver           = "0.0.3"            'version
const module_date          = "23/08/2006"       'date of last change

const ProgressIniFile      = "\bin\progress.ini"
const proRegKey            = "HKEY_LOCAL_MACHINE\SOFTWARE\PSC\AdminService\10.0B\DLC"
const proWinStatic         = "\bin\prowin32.exe"

const ErrorPattern         = "####"
const ProgressNotInstalled = "PROGRESS NOT INSTALLED"

' Helper Libs
Function GetRegKey(strRegPath)
  Dim WSHShell
  On Error Resume Next
  Set WSHShell = CreateObject("WScript.Shell")
  GetRegKey = ProgressNotInstalled
  GetRegKey = WSHShell.RegRead(strRegPath) & ""
End Function

' Returns true if Progress is installed (via the Registry Key proRegKey)
Function ProgressInstalled
  If GetRegKey(proRegKey) = ProgressNotInstalled then
    ProgressInstalled = false
  else
    ProgressInstalled = true
  end if  
End Function

' Returns true if specified FileName (incl. Path) Exists
Function FileExists(strFilename)
  ' create FSO - Object 
  Set oFSO = CreateObject("Scripting.FileSystemObject")
  ' Test, if File exists
  FileExists = oFSO.FileExists(strFilename)
  ' FSO - Object clear
  Set oFSO = Nothing 
End Function

' These are the Functions that handle with Prowin
sub OpenProwin(stringParameter)
  Dim strTemp
  Dim WHShell
  set obj = NewEditor()
  obj.assignActiveEditor
  if FileExists(obj.fileName) then
    obj.saveFile
    strTemp = chr(34) & GetRegKey(proRegKey) + proWinStatic & chr(34) & stringParameter & chr(34) & obj.fileName & chr(34)
    Set WSHShell = WScript.CreateObject("WScript.Shell")    
    'WSHShell.Run("cd " + Left(obj.fileName, InstrRev(obj.fileName, "\")))
    WSHShell.Run(strTemp)
  else
    msgbox "File not present on Disk !", vbCritical
  end if
end sub

sub OpenInAppBuilder
 OpenProwin " -p _ab.p -param "
end sub

sub Run
  OpenProwin " -p "
end sub

sub OpenInProcedureEditor
  OpenProwin " -param "
end sub

sub OpenProgres(stringPathToCheck)
  Dim strTemp, WHShell, oFSO, ts, checkSyntax
  Dim tmpBatFile, tmpLogFile, objBatFile
  set obj = NewEditor()
  obj.assignActiveEditor
  if FileExists(obj.fileName) then
    'create a batch file cause _progres.exe cant redirect with the > operator
    Set oFSO = CreateObject("Scripting.FileSystemObject") 
    'get two temporary files
    tmpBatFile = oFSO.GetTempName & ".bat"
    tmpLogFile = oFSO.GetTempName & ".log"
    tmpChkFile = oFSO.GetTempName & ".p"
    'generate the statements
    'get the Path of the File to Check and add it to batch
    Set objFile = oFSO.GetFile(stringPathToCheck)
    'generate the progres statement
    strTemp = strTemp & chr(34) & GetRegKey(proRegKey) + "\bin\_progres.exe" &_
                        chr(34) & " -b -basekey ini -ininame " & chr(34) & GetRegKey(proRegKey) & ProgressIniFile &_
                        chr(34) & " -p " & chr(34) & tmpChkFile &_
                        chr(34) & " -param " & chr(34) & stringPathToCheck &_
                        chr(34) & " > " & chr(34) & tmpLogFile & chr(34)         
    set obj = NewEditor()
    'open a log window
    obj.AssignLog
'    obj.Text(strTemp) 
    'write the generated batch file to disk
    Set objFile = oFSO.CreateTextFile(tmpBatFile, true)
    objFile.WriteLine(strTemp)
    objFile.Close 
    'generate the SyntaxCheck
    checkSyntax = "MESSAGE PROPATH." & vbcrlf &_
                  "SESSION:SYSTEM-ALERT-BOXES = YES." & vbcrlf &_
                  "COMPILE VALUE(SESSION:PARAMETER)." & vbcrlf &_
                  "IF NOT COMPILER:ERROR" & vbcrlf &_ 
                  "  THEN MESSAGE " & chr(34) & "Syntax is Correct." & chr(34) & vbcrlf &_
                  "    VIEW-AS ALERT-BOX INFORMATION." & vbcrlf &_
                  "ELSE MESSAGE SUBSTITUTE(" & chr(34) & ErrorPattern & "&1*&2*&3" & chr(34) & "," &_
                  "                        COMPILER:FILE-NAME, COMPILER:ERROR-ROW, COMPILER:ERROR-COLUMN)." & vbcrlf &_
                  "QUIT." & vbcrlf
    'write the generated batch file to disk
    Set objFile = oFSO.CreateTextFile(tmpChkFile, true)
    objFile.WriteLine(checkSyntax)
    objFile.Close                   
    'execute the batch file
    Set WSHShell = WScript.CreateObject("WScript.Shell") 
    'WSHShell.Run("cd " + Left(stringPathToCheck, InstrRev(stringPathToCheck, "\")))   
    ReturnCode = WSHShell.Run(tmpBatFile, 0, true)
    'parse the generated log file that is on disk
    txtLogFile = oFSO.OpenTextFile(tmpLogFile, 1).ReadAll
    txtLogFile = Split(txtLogFile, vbCrLf)
    for each strLine in txtLogFile
      x = x + 1
      leftBound = Instr(strLine, ErrorPattern)      
      if (leftBound > 0) and (Flag = False) then
        leftBound = leftBound + len(ErrorPattern)
        Line = mid(strLine, leftBound)
        mCharArray = Split(Line, "*")
        Flag = true
      else
        if (len(obj.Text()) > 0) then
          obj.Text(obj.Text() & vbcrlf & strLine)
        else
          obj.Text(strLine)
        end if      
      end if
    next
    'delete the temporary files
    Set objFile = oFSO.GetFile(tmpBatFile)
    objFile.Delete
    Set objFile = oFSO.GetFile(tmpLogFile)
    objFile.Delete
    Set objFile = oFSO.GetFile(tmpChkFile)
    objFile.Delete
    if Flag = true then
      obj.openFile(mCharArray(0))
      On Error Goto 0
      'obj.command "ecGotoXY{" & Line & ",1}"
      obj.command "ecEditorTop"
      For x = 1 to mCharArray(1)-1
        obj.command "ecDown"
      next
      For x = 1 to mCharArray(2)-1
        obj.command "ecRight"
      next
    end if
  else
    msgbox "File not present on Disk !", vbCritical
  end if
  Set WSHShell = Nothing
end sub

sub CheckSyntax
  set obj = NewEditor()
  obj.assignActiveEditor
  if FileExists(obj.fileName) then
    'save the opened File that should be checked
    obj.saveFile
    OpenProgres obj.fileName
  else
    msgbox "File not present on Disk !", vbCritical
  end if    
end sub

sub ShowInformation
  Dim strText
  strText = "Written by Daniel Krusenbaum" & vbcrlf
  strText = strText & "Using parts of Zane Appels 'Syntax.p'" & vbcrlf & vbcrlf
  strText = strText & module_name & " V" & module_ver & " from " & module_date & vbcrlf & vbcrlf
  strText = strText & "%DLC%      =   '" + GetRegKey(proRegKey) + "'" & vbcrlf
  strText = strText & "RegKey     =   '" + proRegKey + "'"
  msgbox strText, vbInformation, "About '" + module_name + ".vbs'"
end sub

sub OpenScript
  set obj1 = newEditor()
  obj1.openFile(moduleFileName(module_name))
end sub

sub OpenProgressIni
  set obj1 = newEditor()
  obj1.openFile(GetRegKey(proRegKey) & ProgressIniFile)  
end sub

' name "Init" is required, its called automatically during initialization to create menu items
sub Init
  if ProgressInstalled = true then
    addMenuItem "Open in the Procedure Editor", module_name, "OpenInProcedureEditor" 
    addMenuItem "Check Syntax", module_name, "CheckSyntax"   
    addMenuItem "Open in the App Builder", module_name, "OpenInAppBuilder" 
    addMenuItem "Run", module_name, "Run" 
    addMenuItem "-", module_name, ""
    addMenuItem "Open 'progress.ini'", module_name, "OpenProgressIni"
  end if
  addMenuItem "Open script file", module_name, "OpenScript" 
  addMenuItem "-", module_name, ""
  addMenuItem "Show Information", module_name, "ShowInformation"
end sub

